	clear all, close all
	fsample = 100;	L = 5;
	F = [0,0.1,0.8,1];	A = [0,1,0,0];	x = fir2(128,F,A);% Input signal
	[X,f] = freqz(x,1,1000,fsample);	% Input spectrum
	subplot(4,1,1);	PLOT_ABS_f(f, abs(X), 100,'X')
	yup = UP_SAMPLE(x,L);
	[Yup,f] = freqz(yup,1,1000,L*fsample);	% Up-sampled spectrum
	subplot(4,1,2);	PLOT_ABS_f(f, abs(Yup), 250, 'X_u_p')
	axis([0,L*fsample/2,0,1]), grid on	
	
	h = REMEZ_FIR(74,[0,40/250,60/250,1]*pi,[1,1,0,0], [1,10,10],'m'); 
	[H,f] = freqz(h,1,1000,L*fsample);
	subplot(4,1,3), plot(f, H_2_MAG(H),'linewidth',2)
	axis([0,L*fsample/2,-80,0]), grid on
	ylabel(['{|\itH}|  [dB]'],'FontName','times','FontSize',16);
	P = reshape(h,L,length(h)/L);	% Polyphase decomposition
	for n = 1:L % Outputs of the polyphase filters
		yp(n,:) = filter(P(n,:),1,x); 
	end
	y = [yp(1,:);yp(2,:);yp(3,:);yp(4,:);yp(5,:)];	% up-sampling
	[Y,f] = freqz(y,1,1024,L*fsample);	% Interpolated spectrum
	subplot(4,1,4), PLOT_ABS_f(f, abs(Y), 250, 'Y')
	xlabel('{\itf }   [Hz]','FontName','times','FontSize',14);	
	
